package com.ejie.ab04b.dao.xa;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.solicitud.SolicAperturas;

/**
 * SolicitudesDaoImpl generated by UDA, 26-abr-2016 8:07:19.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class SolicAperturasDaoXAImpl extends Ab04bTransactionalXADao implements
		SolicAperturasDaoXA {

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource
	 *            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Method use to set the XA datasource.
	 * 
	 *  dataSourceXA
	 *            DataSource
	 *
	 * @param dataSourceXA the new data source XA
	 */
	@Resource()
	public void setDataSourceXA(DataSource dataSourceXA) {
		this.jdbcTemplateXA = new JdbcTemplate(dataSourceXA);
	}

	/**
	 * Updates a single row in the Solicitudes table.
	 * 
	 *  solicitudes
	 *            Solicitudes
	 *  Solicitudes
	 *
	 * @param solicitudes the solicitudes
	 * @return the solic aperturas
	 */
	public SolicAperturas updateEstado(SolicAperturas solicitudes) {
		String query = "UPDATE AB0456S01 SET ESTADO_SOLICITUD_056 = ? WHERE ID_SOLICITUD_056 = ? ";
		this.obtaninJdbcTemplate().update(query,
				solicitudes.getEstadoSolicitud056(),
				solicitudes.getIdSolicitud056());
		return solicitudes;
	}

}
